import { Github, Twitter, Linkedin, Send } from "lucide-react";
import { Button } from "@/components/ui/button";

const Footer = () => {
  return (
    <footer className="border-t border-border bg-card/50">
      <div className="container mx-auto px-4 py-16">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-10">
          {/* Brand */}
          <div className="lg:col-span-2">
            <div className="flex items-center gap-2 mb-4">
              <div className="w-10 h-10 rounded-xl bg-primary flex items-center justify-center glow-sm">
                <span className="text-primary-foreground font-bold text-xl">D</span>
              </div>
              <span className="text-xl font-bold text-foreground">DexCash</span>
            </div>
            <p className="text-muted-foreground mb-6 max-w-sm">
              La plataforma de intercambio de criptomonedas más segura y fácil de usar. 
              Compra, vende e intercambia más de 100 criptomonedas.
            </p>
            <div className="flex gap-4">
              <a href="#" className="w-10 h-10 rounded-lg bg-secondary flex items-center justify-center hover:bg-primary hover:text-primary-foreground transition-all">
                <Twitter className="w-5 h-5" />
              </a>
              <a href="#" className="w-10 h-10 rounded-lg bg-secondary flex items-center justify-center hover:bg-primary hover:text-primary-foreground transition-all">
                <Github className="w-5 h-5" />
              </a>
              <a href="#" className="w-10 h-10 rounded-lg bg-secondary flex items-center justify-center hover:bg-primary hover:text-primary-foreground transition-all">
                <Linkedin className="w-5 h-5" />
              </a>
              <a href="#" className="w-10 h-10 rounded-lg bg-secondary flex items-center justify-center hover:bg-primary hover:text-primary-foreground transition-all">
                <Send className="w-5 h-5" />
              </a>
            </div>
          </div>

          {/* Products */}
          <div>
            <h4 className="font-semibold text-foreground mb-4">Productos</h4>
            <ul className="space-y-3">
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Exchange</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Wallet</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Tarjeta</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Earn</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">NFTs</a></li>
            </ul>
          </div>

          {/* Resources */}
          <div>
            <h4 className="font-semibold text-foreground mb-4">Recursos</h4>
            <ul className="space-y-3">
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Centro de ayuda</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Blog</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">API</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Comisiones</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Estado</a></li>
            </ul>
          </div>

          {/* Company */}
          <div>
            <h4 className="font-semibold text-foreground mb-4">Empresa</h4>
            <ul className="space-y-3">
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Sobre nosotros</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Carreras</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Prensa</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Legal</a></li>
              <li><a href="#" className="text-muted-foreground hover:text-foreground transition-colors">Privacidad</a></li>
            </ul>
          </div>
        </div>

        {/* Newsletter */}
        <div className="mt-12 p-6 rounded-2xl bg-secondary/50">
          <div className="flex flex-col md:flex-row items-center justify-between gap-4">
            <div>
              <h4 className="font-semibold text-foreground mb-1">Suscríbete a nuestro newsletter</h4>
              <p className="text-sm text-muted-foreground">Recibe las últimas noticias del mercado cripto</p>
            </div>
            <div className="flex gap-2 w-full md:w-auto">
              <input
                type="email"
                placeholder="tu@email.com"
                className="flex-1 md:w-64 px-4 py-2 rounded-lg bg-card border border-border text-foreground placeholder:text-muted-foreground outline-none focus:ring-2 focus:ring-primary"
              />
              <Button variant="glow">
                Suscribir
              </Button>
            </div>
          </div>
        </div>

        {/* Bottom */}
        <div className="mt-12 pt-8 border-t border-border flex flex-col md:flex-row items-center justify-between gap-4">
          <p className="text-sm text-muted-foreground">
            © 2024 DexCash. Todos los derechos reservados.
          </p>
          <div className="flex gap-6 text-sm text-muted-foreground">
            <a href="#" className="hover:text-foreground transition-colors">Términos</a>
            <a href="#" className="hover:text-foreground transition-colors">Privacidad</a>
            <a href="#" className="hover:text-foreground transition-colors">Cookies</a>
          </div>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
