import { Wallet, Menu, X, ChevronDown } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useState } from "react";

const Header = () => {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  return (
    <header className="fixed top-0 left-0 right-0 z-50 glass-strong">
      <div className="container mx-auto px-4">
        <div className="flex items-center justify-between h-16">
          {/* Logo */}
          <div className="flex items-center gap-2">
            <div className="w-10 h-10 rounded-xl bg-primary flex items-center justify-center glow-sm">
              <span className="text-primary-foreground font-bold text-xl">D</span>
            </div>
            <span className="text-xl font-bold text-foreground">DexCash</span>
          </div>

          {/* Desktop Navigation */}
          <nav className="hidden md:flex items-center gap-8">
            <a href="#" className="text-foreground hover:text-primary transition-colors font-medium">
              Mercados
            </a>
            <a href="#" className="text-muted-foreground hover:text-foreground transition-colors">
              Trading
            </a>
            <a href="#" className="text-muted-foreground hover:text-foreground transition-colors">
              Earn
            </a>
            <div className="flex items-center gap-1 text-muted-foreground hover:text-foreground transition-colors cursor-pointer">
              <span>Más</span>
              <ChevronDown className="w-4 h-4" />
            </div>
          </nav>

          {/* Desktop Actions */}
          <div className="hidden md:flex items-center gap-4">
            <div className="flex items-center gap-2 px-4 py-2 rounded-lg bg-secondary">
              <Wallet className="w-4 h-4 text-primary" />
              <span className="text-sm font-medium">$12,450.00</span>
            </div>
            <Button variant="glow" size="sm">
              Depositar
            </Button>
          </div>

          {/* Mobile Menu Button */}
          <button
            className="md:hidden p-2"
            onClick={() => setIsMenuOpen(!isMenuOpen)}
          >
            {isMenuOpen ? (
              <X className="w-6 h-6 text-foreground" />
            ) : (
              <Menu className="w-6 h-6 text-foreground" />
            )}
          </button>
        </div>

        {/* Mobile Menu */}
        {isMenuOpen && (
          <div className="md:hidden py-4 border-t border-border animate-fade-in">
            <nav className="flex flex-col gap-4">
              <a href="#" className="text-foreground font-medium py-2">
                Mercados
              </a>
              <a href="#" className="text-muted-foreground py-2">
                Trading
              </a>
              <a href="#" className="text-muted-foreground py-2">
                Earn
              </a>
              <a href="#" className="text-muted-foreground py-2">
                Más
              </a>
              <div className="flex items-center gap-2 px-4 py-2 rounded-lg bg-secondary w-fit">
                <Wallet className="w-4 h-4 text-primary" />
                <span className="text-sm font-medium">$12,450.00</span>
              </div>
              <Button variant="glow" className="w-full">
                Depositar
              </Button>
            </nav>
          </div>
        )}
      </div>
    </header>
  );
};

export default Header;
