import { useState } from "react";
import { TrendingUp, Shield, Zap, ArrowDownUp, ChevronDown } from "lucide-react";
import { Button } from "@/components/ui/button";

const HeroSection = () => {
  const [activeTab, setActiveTab] = useState<"buy" | "sell">("buy");
  const [amount, setAmount] = useState("");
  const [selectedCrypto, setSelectedCrypto] = useState("BTC");

  const cryptos = [
    { symbol: "BTC", name: "Bitcoin", price: 67432.50, color: "#F7931A" },
    { symbol: "ETH", name: "Ethereum", price: 3456.78, color: "#627EEA" },
    { symbol: "SOL", name: "Solana", price: 178.45, color: "#00FFA3" },
  ];

  const selected = cryptos.find(c => c.symbol === selectedCrypto)!;
  const cryptoAmount = amount ? (parseFloat(amount) / selected.price).toFixed(6) : "0.000000";

  return (
    <section className="relative min-h-screen flex items-center pt-20 pb-16 overflow-hidden">
      {/* Background Effects */}
      <div className="absolute inset-0 bg-glow opacity-50" />
      <div className="absolute top-1/4 left-1/4 w-96 h-96 bg-primary/10 rounded-full blur-3xl animate-pulse-slow" />
      <div className="absolute bottom-1/4 right-1/4 w-80 h-80 bg-accent/10 rounded-full blur-3xl animate-pulse-slow" style={{ animationDelay: '1s' }} />

      <div className="container mx-auto px-4 relative z-10">
        <div className="max-w-xl mx-auto text-center">
          {/* Badge */}
          <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full glass mb-6 animate-fade-in">
            <span className="w-2 h-2 rounded-full bg-success animate-pulse" />
            <span className="text-sm text-muted-foreground">
              Más de 10M+ usuarios activos
            </span>
          </div>

          {/* Main Heading */}
          <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-4 animate-fade-in" style={{ animationDelay: '0.1s' }}>
            Compra y vende{" "}
            <span className="text-gradient">crypto</span>
            <br />
            de forma segura
          </h1>

          {/* Subtitle */}
          <p className="text-base md:text-lg text-muted-foreground mb-8 animate-fade-in" style={{ animationDelay: '0.2s' }}>
            La plataforma más confiable para comprar, vender e intercambiar 
            criptomonedas. Comienza con solo $10.
          </p>

          {/* Trade Widget - Centered */}
          <div className="animate-scale-in" style={{ animationDelay: '0.3s' }}>
            <div className="glass-strong rounded-3xl p-6 glow">
              {/* Tabs */}
              <div className="flex gap-2 p-1 bg-secondary rounded-xl mb-6">
                <button
                  className={`flex-1 py-3 rounded-lg font-semibold transition-all ${
                    activeTab === "buy"
                      ? "bg-success text-success-foreground"
                      : "text-muted-foreground hover:text-foreground"
                  }`}
                  onClick={() => setActiveTab("buy")}
                >
                  Comprar
                </button>
                <button
                  className={`flex-1 py-3 rounded-lg font-semibold transition-all ${
                    activeTab === "sell"
                      ? "bg-destructive text-destructive-foreground"
                      : "text-muted-foreground hover:text-foreground"
                  }`}
                  onClick={() => setActiveTab("sell")}
                >
                  Vender
                </button>
              </div>

              {/* Amount Input */}
              <div className="space-y-4">
                <div className="bg-secondary rounded-2xl p-4">
                  <div className="flex items-center justify-between mb-2">
                    <span className="text-sm text-muted-foreground">
                      {activeTab === "buy" ? "Pagas" : "Vendes"}
                    </span>
                    <span className="text-sm text-muted-foreground">
                      Disponible: $12,450.00
                    </span>
                  </div>
                  <div className="flex items-center gap-4">
                    <input
                      type="number"
                      value={amount}
                      onChange={(e) => setAmount(e.target.value)}
                      placeholder="0.00"
                      className="flex-1 bg-transparent text-3xl font-bold text-foreground outline-none placeholder:text-muted-foreground"
                    />
                    <div className="flex items-center gap-2 px-4 py-2 bg-card rounded-xl cursor-pointer hover:bg-card/80 transition-colors">
                      <span className="text-lg font-semibold">USD</span>
                      <ChevronDown className="w-4 h-4 text-muted-foreground" />
                    </div>
                  </div>
                </div>

                {/* Swap Button */}
                <div className="flex justify-center -my-2 relative z-10">
                  <button className="w-12 h-12 rounded-full bg-primary flex items-center justify-center glow hover:scale-110 transition-transform">
                    <ArrowDownUp className="w-5 h-5 text-primary-foreground" />
                  </button>
                </div>

                {/* Crypto Output */}
                <div className="bg-secondary rounded-2xl p-4">
                  <div className="flex items-center justify-between mb-2">
                    <span className="text-sm text-muted-foreground">
                      {activeTab === "buy" ? "Recibes" : "Obtienes"}
                    </span>
                    <span className="text-sm text-muted-foreground">
                      1 {selected.symbol} = ${selected.price.toLocaleString()}
                    </span>
                  </div>
                  <div className="flex items-center gap-4">
                    <div className="flex-1 text-3xl font-bold text-foreground text-left">
                      {cryptoAmount}
                    </div>
                    <div className="flex items-center gap-2 px-4 py-2 bg-card rounded-xl cursor-pointer hover:bg-card/80 transition-colors">
                      <div
                        className="w-6 h-6 rounded-full flex items-center justify-center text-white text-xs font-bold"
                        style={{ backgroundColor: selected.color }}
                      >
                        {selected.symbol.charAt(0)}
                      </div>
                      <span className="text-lg font-semibold">{selected.symbol}</span>
                      <ChevronDown className="w-4 h-4 text-muted-foreground" />
                    </div>
                  </div>
                </div>
              </div>

              {/* Quick Amounts */}
              <div className="flex gap-2 mt-4">
                {["$100", "$500", "$1,000", "MAX"].map((quick) => (
                  <button
                    key={quick}
                    onClick={() => setAmount(quick === "MAX" ? "12450" : quick.replace(/[$,]/g, ""))}
                    className="flex-1 py-2 text-sm font-medium text-muted-foreground bg-secondary rounded-lg hover:bg-secondary/80 hover:text-foreground transition-all"
                  >
                    {quick}
                  </button>
                ))}
              </div>

              {/* Submit Button */}
              <Button
                variant={activeTab === "buy" ? "success" : "destructive"}
                size="xl"
                className="w-full mt-6"
              >
                {activeTab === "buy" ? "Comprar" : "Vender"} {selected.symbol}
              </Button>

              {/* Fee Info */}
              <div className="flex items-center justify-between mt-4 text-sm text-muted-foreground">
                <span>Comisión de red</span>
                <span>~$2.50</span>
              </div>
            </div>
          </div>

          {/* Stats */}
          <div className="grid grid-cols-3 gap-4 mt-8 animate-fade-in" style={{ animationDelay: '0.4s' }}>
            <div className="glass rounded-xl p-4 text-center">
              <div className="w-10 h-10 rounded-lg bg-primary/20 flex items-center justify-center mx-auto mb-2">
                <TrendingUp className="w-5 h-5 text-primary" />
              </div>
              <div className="text-xl font-bold text-foreground">$156B+</div>
              <div className="text-xs text-muted-foreground">Volumen 24h</div>
            </div>

            <div className="glass rounded-xl p-4 text-center">
              <div className="w-10 h-10 rounded-lg bg-success/20 flex items-center justify-center mx-auto mb-2">
                <Shield className="w-5 h-5 text-success" />
              </div>
              <div className="text-xl font-bold text-foreground">99.9%</div>
              <div className="text-xs text-muted-foreground">Uptime</div>
            </div>

            <div className="glass rounded-xl p-4 text-center">
              <div className="w-10 h-10 rounded-lg bg-warning/20 flex items-center justify-center mx-auto mb-2">
                <Zap className="w-5 h-5 text-warning" />
              </div>
              <div className="text-xl font-bold text-foreground">0.1%</div>
              <div className="text-xs text-muted-foreground">Comisiones</div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HeroSection;
